# Dropzone Action Info
# Name: Save Text
# Description: Creates a new text file in a specified folder with the dropped text and opens it with your default text editor.
# Handles: Text
# Creator: Aptonic
# URL: https://aptonic.com
# OptionsNIB: ChooseFolder
# SkipConfig: No
# RunsSandboxed: Yes
# Version: 1.0
# MinDropzoneVersion: 4.0

def dragged
  destination = "#{ENV['EXTRA_PATH']}"

  $dz.determinate(false)
  $dz.begin("Creating new text file...")

  filename = $dz.inputbox("Save Text", "Enter name for new text file (minus extension):")

  File.open("#{destination}/#{filename}.txt", 'w') do |f|   
    f.write $items[0]
  end

  filename.gsub!(/["`$\\]/){ |s| '\\' + s }
  system("open \"#{destination}/#{filename}.txt\"")

  $dz.finish("Text Saved")
  $dz.url(false)
end

def clicked
  escaped_path = ENV['EXTRA_PATH'].gsub(/["`$\\]/){ |s| '\\' + s }
  system("open \"#{escaped_path}\"")
end
